<?php

namespace VM\ApiBundle\Controller;

use FOS\RestBundle\Controller\Annotations\View;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\BrowserKit\Request;
use Symfony\Component\HttpFoundation\Response;
use VM\ApiBundle\Entity\User;
use VM\ApiBundle\Entity\UserToken;
use VM\ApiBundle\Exceptions\ApiRequestException;
use VM\ApiBundle\Services\FacebookManager;

class FacebookController extends Controller
{
    /**
     * @var null|FacebookManager
     */
    protected $FacebookManager = null;

    public function indexAction()
    {
        $this->FacebookManager = $this->get('facebook.manager');
        $this->FacebookManager->destroySession();
        $facebookUserId = $this->FacebookManager->getUser();

        if($facebookUserId)
        {
            try
            {
                $ApiUser = $this->get('api.user');
//                Array(id,email,first_name,gender,last_name,link,locale,name,timezone,updated_time,verified)
                $user_profile = $this->FacebookManager->api('/me');

                $loginData = $ApiUser->login_by_facebook($user_profile);
                $url = $this->container->getParameter('facebook_podreczniki_autologin_url');

                return $this->redirect($url.'/'.$loginData['user_id'].'/'.$loginData['token']);
            }
            catch(\FacebookApiException $e)
            {
                $this->FacebookManager->destroySession();
                $login_url = $this->FacebookManager->getLoginUrl();

                return $this->redirect($login_url);
            }
        }
        else
        {
            $login_url = $this->FacebookManager->getLoginUrl();

            return $this->redirect($login_url);
        }
    }

    public function logoutAction()
    {
        $FacebookManager = $this->get('facebook.manager');
        $FacebookManager->destroySession();

        return $this->redirect($this->generateUrl('vm_login_facebook'));
    }
}
